@extends('user')
@section('content')
    @include('partials.breadcrumb')
    <div class="dedicated-plan">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    @include('errors.error')
                    <div class="plan-table">
                        <table class="table">
                            <thead>
                            <tr>
                                <th scope="col">@lang('SL')</th>
                                <th scope="col">@lang('Transaction ID')</th>
                                <th scope="col">@lang('Details')</th>
                                <th scope="col">@lang('Amount')</th>
                                <th scope="col">@lang('Time')</th>
                            </tr>
                            </thead>

                            <tbody>
                            @if(count($deposit) >0)
                                @foreach($deposit as $k=>$data)
                                    <tr>
                                        <td data-label="SL">{{++$k}}</td>
                                        <td data-label="#Trx">{{isset($data->trx ) ? $data->trx  : 'N/A'}}</td>
                                        <td data-label="Details">{{isset($data->gateway->name) ? $data->gateway->name : 'N/A'}} </td>
                                        <td data-label="Amount">{{$data->amount}}</span> {!! $basic->currency !!}</td>
                                        <td data-label="Time">
                                            {!! date(' d M Y h:i A', strtotime($data->created_at)) !!}
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="5"> @lang("No Data Found!!")</td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                    </div>
                    {!! $deposit->links() !!}
                </div>
            </div>
        </div>
    </div>
@stop
